# import libraries
import numpy as np
from matplotlib import pyplot as plt
plt.close('all')
# Loading results files
Sensor_acceleration = np.loadtxt("resultsR/dirdyn_A.res")
Sensor_velocity     = np.loadtxt("resultsR/dirdyn_V.res")
Sensor_position     = np.loadtxt("resultsR/dirdyn_P.res")
Tyre_Ground_Force   = np.loadtxt("resultsR/dirdyn_Fz.res")
q = np.loadtxt("resultsR/dirdyn_q.res")
kinematics = np.loadtxt("resultsR/dirdyn_kinematics.res")

gamma = kinematics[:, 4]
delta = kinematics[:, 5]
# plotting
# f, axarr = plt.subplots(4, sharex=True)
# axarr[0].set_title("Vertical position of the wheel")
# axarr[0].set_ylabel('[m]')
# axarr[0].set_xlabel('[sec]')
# axarr[0].plot(Sensor_position[:,0], Sensor_position[:,1])
# plt.xlim(0,5)

# axarr[1].set_title("Vertical velocity of the wheel")
# axarr[1].set_ylabel('[m/sec]')
# axarr[1].set_xlabel('[sec]')
# axarr[1].plot(Sensor_velocity[:,0], Sensor_velocity[:,1])

# axarr[2].set_title("Vertical acceleration of the wheel")
# axarr[2].set_ylabel('[m/sec^2]')
# axarr[2].set_xlabel('[sec]')
# axarr[2].plot(Sensor_acceleration[:,0], Sensor_acceleration[:,1])

# axarr[3].set_title("Tyre vertical force")
# axarr[3].set_ylabel('[N]')
# axarr[3].set_xlabel('[sec]')
# axarr[3].plot(Tyre_Ground_Force[:,0], Tyre_Ground_Force[:,1])
# plt.title("Tyre vertical force")
# plt.show()


# ids = [10, 12, 16]
# plt.figure(figsize=(14, 7.25))
# for i in ids:
#     plt.plot(q[:, 0], q[:, i])
# # plt.plot(q[:,0], q[:,35], label='M3')
# # plt.plot(q[:,0], q[:,36], label='M2')
# # plt.plot(q[:,0], q[:,34], label='M1')


plt.figure(figsize=(14, 7.25))
plt.plot(q[:, 18]-0.3, np.rad2deg(gamma))
plt.legend()
plt.xlabel('wheel height [m]')
plt.ylabel('Camber angle [degree]')

plt.figure(figsize=(14, 7.25))
plt.plot(q[:, 18]-0.3, np.rad2deg(delta))
plt.legend()
plt.xlabel('wheel height [m]')
plt.ylabel('Steer angle [degree]')

plt.figure(figsize=(14, 7.25))
plt.plot(q[:, 18]-0.3, q[:, 16])
plt.legend()
plt.xlabel('wheel height [m]')
plt.ylabel('Steer angle [degree]')
